
#include "..\config.h"

#include "userDataProcess.h"

/*********************************************************************************************************
  
*********************************************************************************************************/
#define LED1        (1 << 0)                           // P2.0 is used to control LED1 
#define LED1OFF()   FIO2SET = LED1                     // LED1 off
#define LED1ON()    FIO2CLR = LED1                     // LED1 ON     


int main (void)
{
    INT8U demoFlag = 0;        // diaplay mode flag,   0-> contiually ;     1(non 0)-> freeze at current pic    
    INT8U picIndex = 0;        // index of demo pic   

    targetInit();                             // Target MCU initialization  
    pinInit();                                // MCU PIN initialization                                                                                  

    FIO2DIR |= LED1;                          // P2.0 is Output foot 
    keyInit();		                          // Initialize Key as input

	lcdPinInit();                             // Initialize RST, CD, RW, E as output
    lcdInit();                                // Initialize ST7567
	
    cleanScreen();    // clean screen
	
	while (1) {
        
		if ((FIO2PIN & KEY1) == 0) {          // 
            if (demoFlag == 0) {
			    demoFlag = 1;
			}
			else {
			    demoFlag = 0;
			}
	    } 
	    else {					              // 
            //Action Code
	    }
		/*
		if ((FIO2PIN & KEY2) == 0) {          // 
            //Action Code
	    } 
		else {					              // 
            //Action Code
	    } */

		
		if (demoFlag == 0) {
		    picIndex++;
			if (picIndex>2) {
			    picIndex=0;
            }
            
            switch (picIndex) {
                case 0: {
                    cleanScreen();    // clean screen
                    printString(1,1,"AMC1202AR-B ");
		            printString(2,1," -G6NFDY-SP  ");
					break;
				}
				case 1: {
                    cleanScreen();    // clean screen
                    printString(1,1,"   Orient   ");
		            printString(2,1,"   Display  ");
					break;
				}
				case 2: {
                    cleanScreen();    // clean screen
                    printString(1,1,"  Your LCD  ");
		            printString(2,1,"   Expert   ");
					break;
				}default: break;
			}
		}

		delayMs(1500);  
    }
}

/*********************************************************************************************************
  End Of File
*********************************************************************************************************/
